#!/bin/sh
#
# graymilter.sh - startup script for graymilter on FreeBSD
#
# This should be manually installed as:
#   /usr/local/etc/rc.d/graymilter
# It gets run at boot-time.
#
# Variables available:
#   graymilter_enable='YES'
#   graymilter_program='path'
#   graymilter_socket='path'
#   graymilter_flags='flags'

# PROVIDE: graymilter
# REQUIRE: LOGIN FILESYSTEMS
# BEFORE: mail

. /etc/rc.subr

name='graymilter'
rcvar='graymilter_enable'

load_rc_config "$name"

# Defaults.
graymilter_enable="${graymilter_enable:-NO}"
graymilter_program="${graymilter_program:-/usr/local/sbin/graymilter}"
graymilter_socket="${graymilter_socket:-/var/run/graymilter.sock}"

# Add socket to any given argument.
graymilter_flags="${graymilter_flags} ${graymilter_socket}"

command="$graymilter_program"

run_rc_command "$1"
